<?php

return array(
	1 => array(
		'title'       => esc_html__( 'Replacing the logo in Header Builder', 'woodmart' ),
		'description' => esc_html__( 'Discover how to change the main logo of the website', 'woodmart' ),
		'url'         => admin_url( 'admin.php?page=xts_dashboard' ),
		'steps'       => array(
			array(
				'title'       => esc_html__( 'Open Header Builder', 'woodmart' ),
				'description' => esc_html__( 'Click the Header Builder icon in the top bar of the admin panel.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.xts-header .xts-nav-item .xts-nav-link.xts-i-header-builder',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Manage your headers', 'woodmart' ),
				'description' => esc_html__( 'This is the Header Builder panel, where you can add, delete, or import headers. Click "Next" to continue.', 'woodmart' ),
				'type'        => 'info',
				'selector'    => '.whb-header-builder',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Edit the active header', 'woodmart' ),
				'description' => esc_html__( 'To access the settings of the active header, click the "Edit" button.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-headers-manager .whb-header-item.whb-header-default .whb-button.xts-i-edit-write',
				'step'        => 1,
				'is_done'     => "var interval = setInterval(() => {if (jQuery('.whb-header-builder:not(.xts-loading) .whb-headers-manager.whb-area-desktop').length){clearInterval(interval);callback();}}, 500);",
			),
			array(
				'title'       => esc_html__( 'Header layout settings', 'woodmart' ),
				'description' => esc_html__( 'This panel contains the settings for the current header. You can change the color, size, block arrangement, or add new elements. Click "Next" to continue.', 'woodmart' ),
				'type'        => 'info',
				'selector'    => '.whb-headers-manager.whb-area-desktop',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Switch to Frontend editor', 'woodmart' ),
				'description' => esc_html__( 'Click the "Frontend Editor" button to enable live visual editing of your header.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-headers-manager .whb-frontend-editor',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Customize header layout in frontend', 'woodmart' ),
				'description' => esc_html__( 'This allows you to view and edit the header directly in the live preview of your website, providing a more intuitive and accurate editing experience.', 'woodmart' ),
				'type'        => 'info',
				'selector'    => 'body.wd-header-editor [id="whb-header-builder"]',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Access the logo settings', 'woodmart' ),
				'description' => esc_html__( 'This is your website logo element in the desktop header. Hover over it and click the "Pencil" icon to continue.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-headers-manager .whb-element-content .whb-element-logo',
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Configure logo element', 'woodmart' ),
				'description' => esc_html__( 'In this popup window, you’ll find all the settings related to the logo used in the desktop version of the header. You can also configure a separate logo for the sticky header. Click "Next" to continue.', 'woodmart' ),
				'type'        => 'info',
				'selector'    => '.xts-popup-holder .whb-popup-inner',
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Upload your logo', 'woodmart' ),
				'description' => esc_html__( 'Select your desktop logo from the Media Library or upload one from your device.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-popup .whb-image-option .whb-imagepicker .whb-upload-button',
				'step'        => 3,
				'is_done'     => "wp.media.frame.on('close', () => {callback()});",
			),
			array(
				'title'       => esc_html__( 'Save logo changes', 'woodmart' ),
				'description' => esc_html__( 'Done! The desktop logo has been successfully uploaded. Click "Save" to continue.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-popup .whb-popup-actions .whb-button.xts-i-save',
				'step'        => 3,
				'is_done'     => "var interval = setInterval(() => {if (jQuery('.whb-header-builder:not(.xts-loading) .whb-headers-manager.whb-area-desktop').length){clearInterval(interval);callback();}}, 500);",
			),
			array(
				'title'       => esc_html__( 'Switch to mobile header view', 'woodmart' ),
				'description' => esc_html__( 'Click the "Mobile" button in the Header Builder to view and edit the mobile version of your header.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-headers-manager .whb-toolbar .xts-buttons-control .whb-button.xts-i-phone',
				'step'        => 4,
			),
			array(
				'title'       => esc_html__( 'Overview of the mobile header', 'woodmart' ),
				'description' => esc_html__( 'The mobile header may have a different layout compared to the desktop version. Ensure that all important elements, such as navigation, icons, and menus, are properly arranged for mobile view. Click "Next" to continue.', 'woodmart' ),
				'type'        => 'info',
				'selector'    => 'body.wd-header-editor [id="whb-header-builder"]',
				'step'        => 4,
			),
			array(
				'title'       => esc_html__( 'Access the logo settings', 'woodmart' ),
				'description' => esc_html__( 'This is your website logo element in the mobile header. Hover over it and click the "Pencil" icon to continue.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-headers-manager .whb-element-content .whb-element-logo',
				'step'        => 4,
			),
			array(
				'title'       => esc_html__( 'Configure mobile logo element', 'woodmart' ),
				'description' => esc_html__( 'In this popup window, you can upload a logo specifically for the mobile header. You can also set a different logo for the sticky mobile header.', 'woodmart' ),
				'type'        => 'info',
				'selector'    => '.xts-popup-holder .whb-popup-inner',
				'step'        => 4,
			),
			array(
				'title'       => esc_html__( 'Upload your logo', 'woodmart' ),
				'description' => esc_html__( 'Choose your mobile logo from the Media Library or upload one from your device.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-popup .whb-image-option .whb-imagepicker .whb-upload-button',
				'step'        => 4,
				'is_done'     => "wp.media.frame.on('close', () => {callback()});",
			),
			array(
				'title'       => esc_html__( 'Save logo changes', 'woodmart' ),
				'description' => esc_html__( 'Done! The mobile logo has been successfully uploaded. Click "Save" to continue.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-popup .whb-popup-actions .whb-button.xts-i-save',
				'step'        => 4,
				'is_done'     => "var interval = setInterval(() => {if (jQuery('.whb-header-builder:not(.xts-loading) .whb-headers-manager.whb-area-mobile').length){clearInterval(interval);callback();}}, 500);",
			),
			array(
				'title'       => esc_html__( 'Save changes to header', 'woodmart' ),
				'description' => esc_html__( 'Click "Save header" to apply and save all changes made to the current header.', 'woodmart' ),
				'type'        => 'button',
				'selector'    => '.whb-headers-manager .whb-builder-actions .whb-button.xts-i-save',
				'is_done'     => "var i=setInterval(()=>{if(jQuery('.whb-header-builder:not(.xts-loading) .whb-messages-area .xts-success').length){clearInterval(i);callback()}},500);",
				'step'        => 5,
			),
			array(
				'title'       => esc_html__( 'Finish setup', 'woodmart' ),
				'description' => esc_html__( 'Congratulations! You’ve successfully replaced the default logo with your own. Click the "Done" button to finish.', 'woodmart' ),
				'type'        => 'info',
				'selector'    => 'body.wd-header-editor [id="whb-header-builder"]',
				'step'        => 5,
			),
		),
	),
	2 => array(
		'title'       => esc_html__( 'Customize styles and colors', 'woodmart' ),
		'description' => esc_html__( 'Find out how to change the primary color settings', 'woodmart' ),
		'url'         => admin_url( 'admin.php?page=xts_dashboard' ),
		'steps'       => array(
			array(
				'title'       => esc_html__( 'Open Theme settings', 'woodmart' ),
				'description' => esc_html__( 'This is where all visual customization begins.', 'woodmart' ),
				'selector'    => '.xts-header .xts-nav-item .xts-nav-link.xts-i-theme-settings',
				'step'        => 1,
				'type'        => 'button',
			),
			array(
				'title'       => esc_html__( 'Manage Theme settings', 'woodmart' ),
				'description' => esc_html__( 'This panel allows you to modify most aspects of your site’s appearance.', 'woodmart' ),
				'selector'    => '.xts-options.xts-theme-style',
				'type'        => 'info',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Go to the "Styles and colors" section', 'woodmart' ),
				'description' => esc_html__( 'All customization options for colors and styles are available here.', 'woodmart' ),
				'selector'    => '.xts-box-content .xts-nav a[data-id="general_styles_section"]',
				'type'        => 'button',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Explore "Styles and colors" section', 'woodmart' ),
				'description' => esc_html__( 'In these submenus, you can modify colors, page backgrounds, border radius, button styles, form fields, and carousel navigation.', 'woodmart' ),
				'selector'    => '.xts-box-content .xts-nav .xts-has-child.xts-active-nav',
				'type'        => 'info',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Select the "Colors" menu item', 'woodmart' ),
				'description' => esc_html__( 'This section contains all the global color controls for your website.', 'woodmart' ),
				'selector'    => '.xts-box-content .xts-nav .xts-has-child.xts-active-nav a[data-id="colors_section"]',
				'type'        => 'button',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Explore color settings', 'woodmart' ),
				'description' => esc_html__( 'Here you’ll find options for primary color, secondary color, and links color — these are key elements that define your website’s visual identity.', 'woodmart' ),
				'selector'    => '.xts-section[data-id="colors_section"] .xts-fields',
				'type'        => 'info',
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Change primary color', 'woodmart' ),
				'description' => esc_html__( 'The primary color is used for buttons, active elements, and highlights across your site. Try clicking the color picker to change this color.', 'woodmart' ),
				'selector'    => '.xts-section[data-id="colors_section"] .xts-primary-color-field .wp-color-result',
				'type'        => 'button',
				'step'        => 3,
				'is_done'     => "jQuery('body').one('click.wpcolorpicker', function(){callback()})",
			),
			array(
				'title'       => esc_html__( 'Change secondary color', 'woodmart' ),
				'description' => esc_html__( 'The secondary color is used for secondary accents and complementary elements that may contrast with the primary color. Try clicking the color picker to change this color.', 'woodmart' ),
				'selector'    => '.xts-section[data-id="colors_section"] .xts-secondary-color-field .wp-color-result',
				'type'        => 'button',
				'step'        => 3,
				'is_done'     => "jQuery('body').one('click.wpcolorpicker', function(){callback()})",
			),
			array(
				'title'       => esc_html__( 'Save your changes', 'woodmart' ),
				'description' => esc_html__( 'Click the "Save" button to apply all changes made in the Theme settings panel.', 'woodmart' ),
				'selector'    => '.xts-options-actions .xts-save-options-btn',
				'type'        => 'button',
				'step'        => 4,
				'is_done'     => "var i=setInterval(()=>{if(jQuery('.xts-options .xts-notices-wrapper .xts-notice.xts-success').length){clearInterval(i);callback()}},500);",
			),
			array(
				'title'       => esc_html__( 'All done!', 'woodmart' ),
				'description' => esc_html__( 'You’ve successfully customized your site’s styles and colors. Click the "Done" button to finish.', 'woodmart' ),
				'selector'    => '.xts-options.xts-theme-style .xts-box-content',
				'type'        => 'info',
				'step'        => 4,
			),
		),
	),
	3 => array(
		'title'       => esc_html__( 'Set up basic typography', 'woodmart' ),
		'description' => esc_html__( 'Explore how to change the font, its size, and color', 'woodmart' ),
		'url'         => admin_url( 'admin.php?page=xts_dashboard' ),
		'steps'       => array(
			array(
				'title'       => esc_html__( 'Open Theme settings', 'woodmart' ),
				'description' => esc_html__( 'Click on the Theme settings menu item in the main menu of the admin panel.', 'woodmart' ),
				'selector'    => '.xts-header .xts-nav-item .xts-nav-link.xts-i-theme-settings',
				'step'        => 1,
				'type'        => 'button',
			),
			array(
				'title'       => esc_html__( 'Manage Theme settings', 'woodmart' ),
				'description' => esc_html__( 'This panel allows you to modify most aspects of your site’s appearance.', 'woodmart' ),
				'selector'    => '.xts-options.xts-theme-style',
				'type'        => 'info',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Go to the "Typography" section', 'woodmart' ),
				'description' => esc_html__( 'Click on the "Typography" menu item to open font customization options.', 'woodmart' ),
				'selector'    => '.xts-box-content .xts-nav a[data-id="general_typography_section"]',
				'type'        => 'button',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Explore "Typography" section', 'woodmart' ),
				'description' => esc_html__( 'These section are organized by purpose:', 'woodmart' ) . '<ul>' .
					'<li>' . __( '<b>Basic</b> for general text settings', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Advanced</b> for fine-tuning', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Custom fonts</b> for uploading your own typefaces', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Icon fonts</b> for managing symbol fonts', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Adobe fonts</b> for integrating with Adobe’s service', 'woodmart' ) . '</li></ul>',
				'selector'    => '.xts-box-content .xts-nav .xts-has-child.xts-active-nav',
				'type'        => 'info',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Typography settings overview', 'woodmart' ),
				'description' => esc_html__( 'This section lets you control the appearance of text across your entire site — including body text and headings.', 'woodmart' ),
				'selector'    => '.xts-section[data-id="typography_section"] .xts-fields',
				'type'        => 'info',
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Adjust text font options', 'woodmart' ),
				'description' => esc_html__( 'This options defines the default typography for your site’s body text, including paragraphs and general content. You’ll find several key controls here: font family, font weight, font subset, font size and color. Review and change these settings as needed. When you’re done, click "Next" to continue.', 'woodmart' ),
				'selector'    => '.xts-section[data-id="typography_section"] .xts-single-typography[data-id="text-font"] .xts-font-section',
				'type'        => 'info',
				'allow_click' => true,
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Adjust title font options', 'woodmart' ),
				'description' => esc_html__( 'This options controls the typography for all heading elements on your site, such as h1–h6 tags. You can modify several controls: font family, font weight, font subset, font size, and color. Choose values that fit your site’s visual hierarchy. Then, click "Next" to proceed.', 'woodmart' ),
				'selector'    => '.xts-section[data-id="typography_section"] .xts-single-typography[data-id="primary-font"] .xts-font-section',
				'type'        => 'info',
				'allow_click' => true,
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Save your changes', 'woodmart' ),
				'description' => esc_html__( 'Click the "Save" button to apply all changes made in the Theme settings panel.', 'woodmart' ),
				'selector'    => '.xts-options-actions .xts-save-options-btn',
				'type'        => 'button',
				'step'        => 4,
				'is_done'     => "var i=setInterval(()=>{if(jQuery('.xts-options .xts-notices-wrapper .xts-notice.xts-success').length){clearInterval(i);callback()}},500);",
			),
			array(
				'title'       => esc_html__( 'All done!', 'woodmart' ),
				'description' => esc_html__( 'You’ve successfully customized your site’s typography for text and headings. Click the "Done" button to finish.', 'woodmart' ),
				'selector'    => '.xts-options.xts-theme-style .xts-box-content',
				'type'        => 'info',
				'step'        => 4,
			),
		),
	),
	4 => array(
		'title'       => esc_html__( 'Edit the main navigation menu', 'woodmart' ),
		'description' => esc_html__( 'Learn how to edit or add items to the main menu', 'woodmart' ),
		'url'         => admin_url( 'admin.php?page=xts_dashboard' ),
		'steps'       => array(
			array(
				'title'       => esc_html__( 'Hover over "Appearance"', 'woodmart' ),
				'description' => esc_html__( 'In the WordPress dashboard, hover over the "Appearance" section in the sidebar.', 'woodmart' ),
				'selector'    => '#adminmenu #menu-appearance > a',
				'type'        => 'hover',
				'offset'      => 400,
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Open menus settings', 'woodmart' ),
				'description' => esc_html__( 'Click on "Menus" in the dropdown that appears.', 'woodmart' ),
				'selector'    => '#adminmenu #menu-appearance .wp-submenu a[href*="nav-menus.php"]',
				'type'        => 'button',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'What is the "Menus" section?', 'woodmart' ),
				'description' => esc_html__( 'This is where you create new menus, edit existing ones, and assign them to different locations on your site.', 'woodmart' ),
				'selector'    => 'body.nav-menus-php .wrap',
				'type'        => 'info',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Go to the "Manage Locations" tab', 'woodmart' ),
				'description' => esc_html__( 'Click on the "Manage Locations" tab at the top of the Menus screen.', 'woodmart' ),
				'selector'    => 'body.nav-menus-php .nav-tab-wrapper a[href*="nav-menus.php?action=locations"]',
				'type'        => 'button',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Explore menu locations', 'woodmart' ),
				'description' => esc_html__( 'In this table, you’ll see two default menu positions in WordPress:', 'woodmart' ) .
					'<ul><li>' . __( '<b>Main Menu</b> – the primary navigation shown on desktop.', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Mobile Side Menu</b> – the navigation used for mobile view.', 'woodmart' ) . '</li></ul>',
				'selector'    => 'body.nav-menus-php #menu-locations-wrap table',
				'type'        => 'info',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Edit or create a menu', 'woodmart' ),
				'description' => esc_html__( 'Click "Edit" to modify an existing menu, or click "Use new menu" to create one from scratch.', 'woodmart' ),
				'selector'    => 'body.nav-menus-php #locations-main-menu + .locations-row-links',
				'type'        => 'button',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Enter menu name', 'woodmart' ),
				'description' => esc_html__( 'Type a name for your new menu in the "Menu name" field. This name is for internal use only and helps you identify the menu later.', 'woodmart' ),
				'selector'    => 'body.nav-menus-php .menu-edit input.menu-name',
				'type'        => 'info',
				'allow_click' => true,
				'step'        => 2,
				'skip_if'     => "0 != jQuery('input#menu').val()",
			),
			array(
				'title'       => esc_html__( 'Save the menu', 'woodmart' ),
				'description' => esc_html__( 'Click the "Create menu" button to save your new menu. You’ll now be able to add menu items and assign it to a location.', 'woodmart' ),
				'selector'    => 'body.nav-menus-php #nav-menu-footer #save_menu_footer',
				'type'        => 'button',
				'step'        => 2,
				'skip_if'     => "0 != jQuery('input#menu').val()",
				'is_done'     => "var i=setInterval(()=>{if(0 != jQuery('input#menu').val()){clearInterval(i);callback()}},1000);",
			),
			array(
				'title'       => esc_html__( 'Select item to add', 'woodmart' ),
				'description' => esc_html__( 'Choose the page you want to add to your menu.', 'woodmart' ),
				'selector'    => '#add-post-type-page-content #pagechecklist-most-recent',
				'type'        => 'button',
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Add item to the menu', 'woodmart' ),
				'description' => esc_html__( 'After selecting the item, click the "Add to Menu" button to include them in your menu structure on the right.', 'woodmart' ),
				'selector'    => '#add-post-type-page-content #submit-posttype-page',
				'type'        => 'button',
				'step'        => 3,
				'is_done'     => "var i=setInterval(()=>{if(!jQuery('#add-post-type-page-content #submit-posttype-page').siblings('.spinner').hasClass('is-active')){clearInterval(i);callback()}},500);",
			),
			array(
				'title'       => esc_html__( 'Expand the menu item', 'woodmart' ),
				'description' => esc_html__( 'Click the arrow on the newly added menu item to expand its settings.', 'woodmart' ),
				'selector'    => 'body.nav-menus-php #menu-to-edit .menu-item.menu-item-depth-0:last-child .menu-item-handle',
				'type'        => 'button',
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Explore menu item settings', 'woodmart' ),
				'description' => esc_html__( 'Each menu item includes several customization options: ', 'woodmart' ) .
					'<ul><li>' . __( '<b>Navigation label</b> – the text shown in the menu.', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Title attribute</b> – optional tooltip shown on hover.', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Dropdown settings</b> – submenu design and appearance selection.', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Label settings</b> – adding a color label next to the menu item title.', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Image settings</b> – set an icon or background for the menu item.', 'woodmart' ) . '</li>' .
					'<li>' . __( '<b>Extra options</b> – additional menu item settings.', 'woodmart' ) . '</li></ul>' .
					esc_html__( 'Review these options and make any necessary changes. Once you\'re done, click "Next" to continue.', 'woodmart' ),
				'selector'    => 'body.nav-menus-php #menu-to-edit .menu-item.menu-item-depth-0:last-child .menu-item-settings',
				'allow_click' => true,
				'type'        => 'info',
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Save your menu', 'woodmart' ),
				'description' => esc_html__( 'Click the "Save menu" button to apply all your changes and make the menu active on your site.', 'woodmart' ),
				'selector'    => 'body.nav-menus-php #nav-menu-footer #save_menu_footer',
				'type'        => 'button',
				'step'        => 4,
				'is_done'     => "var i=setInterval(()=>{if(jQuery('#message.updated').length){clearInterval(i);callback()}},1000);",
				'skip_if'     => "jQuery('#message.updated').length",
			),
			array(
				'title'       => esc_html__( 'All done!', 'woodmart' ),
				'description' => esc_html__( 'Your WordPress menu is now ready. You’ve successfully updated your menu, added items, configured settings, and saved it. Your changes are now live on your site. Click the "Done" button to finish.', 'woodmart' ),
				'selector'    => 'body.nav-menus-php .wrap div[id="message"] ~ #nav-menus-frame div[id="menu-management-liquid"]',
				'type'        => 'info',
				'step'        => 4,
			),
		),
	),
	5 => array(
		'title'       => esc_html__( 'Modifying the site content via Elementor', 'woodmart' ),
		'description' => esc_html__( 'Find out how to update the homepage title step by step', 'woodmart' ),
		'url'         => admin_url( 'admin.php?page=xts_dashboard' ),
		'requires'    => woodmart_is_elementor_installed() && get_post_meta( get_option( 'page_on_front' ), '_elementor_edit_mode', true ),
		'steps'       => array(
			array(
				'title'       => esc_html__( 'Go to the Homepage', 'woodmart' ),
				'description' => esc_html__( 'Click the site name in the top admin bar to navigate to the homepage of your website.', 'woodmart' ),
				'selector'    => '#wpadminbar #wp-admin-bar-site-name > a',
				'type'        => 'button',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Homepage overview', 'woodmart' ),
				'description' => esc_html__( 'This is the homepage of your website. It displays the content that visitors see first, including banners, titles, and key sections.', 'woodmart' ),
				'selector'    => 'body',
				'type'        => 'info',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Edit the page', 'woodmart' ),
				'description' => esc_html__( 'Click the "Edit page" button in the top admin bar to open the homepage in the Elementor editor.', 'woodmart' ),
				'selector'    => '#wpadminbar #wp-admin-bar-edit > a',
				'type'        => 'button',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Page editor overview', 'woodmart' ),
				'description' => esc_html__( 'You are now in the WordPress page editor. When using Elementor, this page serves as a transitional screen between WordPress and the Elementor editor. Click "Next" to proceed.', 'woodmart' ),
				'selector'    => '#editor',
				'type'        => 'info',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Edit with Elementor', 'woodmart' ),
				'description' => esc_html__( 'Click on the "Edit with Elementor" button to launch the Elementor page builder and start editing the content of your page with its powerful tools.', 'woodmart' ),
				'selector'    => '.elementor-editor-active #elementor-editor-button, body:not(.elementor-editor-active) #elementor-switch-mode-button',
				'step'        => 2,
				'type'        => 'button',
				'is_done'     => "var i=setInterval(()=>{if(jQuery('#elementor-go-to-edit-page-link').hasClass('elementor-animate')){clearInterval(i);callback()}},1000);",
				'skip_if'     => "jQuery('.elementor-editor-active.elementor-editor-wp-page').length",
			),
			array(
				'title'       => esc_html__( 'Elementor editor overview', 'woodmart' ),
				'description' => esc_html__( 'Here, you\'ll see two areas: the sidebar panel with available elements and the main area for editing your page content.', 'woodmart' ),
				'selector'    => '.elementor-editor-active',
				'step'        => 3,
				'type'        => 'info',
			),
			array(
				'title'       => esc_html__( 'Select the "Section title" element', 'woodmart' ),
				'description' => esc_html__( 'Click on the "Section title" element to select the heading section you want to edit.', 'woodmart' ),
				'selector'    => 'body iframe .elementor-element-edit-mode .elementor-widget-wd_title[draggable] .elementor-widget-container',
				'step'        => 3,
				'type'        => 'button',
			),
			array(
				'title'       => esc_html__( 'Customize content and style', 'woodmart' ),
				'description' => esc_html__( 'Here, you can edit the content fields, adjust element-specific settings, and apply style changes such as colors, spacing, and typography. Once you\'re done customizing the content and design of the element, click "Next".', 'woodmart' ),
				'selector'    => '#elementor-panel-content-wrapper',
				'type'        => 'info',
				'allow_click' => true,
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Save the page', 'woodmart' ),
				'description' => esc_html__( 'After making all the necessary changes to the title element, click the "Publish" button to save your changes.', 'woodmart' ),
				'selector'    => '.MuiButtonGroup-root > button',
				'step'        => 4,
				'type'        => 'button',
				'is_done'     => "var i=setInterval(()=>{if(jQuery('.MuiButtonGroup-root > .MuiButtonBase-root.Mui-disabled').length){clearInterval(i);callback()}},1000);",
			),
			array(
				'title'       => esc_html__( 'All done!', 'woodmart' ),
				'description' => esc_html__( 'Your homepage title has been successfully updated – the changes are now live. Click the "Done" button to finish.', 'woodmart' ),
				'selector'    => '.elementor-editor-active',
				'step'        => 4,
				'allow_click' => true,
				'type'        => 'info',
			),
		),
	),
	6 => array(
		'title'       => esc_html__( 'Modifying the site content via Gutenberg', 'woodmart' ),
		'description' => esc_html__( 'Find out how to update the homepage title step by step', 'woodmart' ),
		'url'         => admin_url( 'admin.php?page=xts_dashboard' ),
		'requires'    => has_blocks( (int) get_option( 'page_on_front' ) ),
		'steps'       => array(
			array(
				'title'       => esc_html__( 'Go to the Homepage', 'woodmart' ),
				'description' => esc_html__( 'Click the site name in the top admin bar to navigate to the homepage of your website.', 'woodmart' ),
				'selector'    => '#wpadminbar #wp-admin-bar-site-name > a',
				'type'        => 'button',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Homepage overview', 'woodmart' ),
				'description' => esc_html__( 'This is the homepage of your website. It displays the content that visitors see first, including banners, titles, and key sections.', 'woodmart' ),
				'selector'    => 'body',
				'type'        => 'info',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Edit the page', 'woodmart' ),
				'description' => esc_html__( 'Click the "Edit page" button in the top admin bar to open the homepage in the block editor.', 'woodmart' ),
				'selector'    => '#wpadminbar #wp-admin-bar-edit > a',
				'type'        => 'button',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Page editor overview', 'woodmart' ),
				'description' => esc_html__( 'You are now in the WordPress block editor. Here, you can manage the layout and content of your page using blocks such as headings, paragraphs, images, and more.', 'woodmart' ),
				'selector'    => '#editor',
				'type'        => 'info',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Select the title block', 'woodmart' ),
				'description' => esc_html__( 'Click on the title block on the page. This is typically a heading block that displays the main title of the section or page.', 'woodmart' ),
				'selector'    => '.is-root-container > .wp-block-wd-title, .is-root-container > .wp-block-wd-container > .block-editor-inner-blocks > .block-editor-block-list__layout > .wp-block-wd-title',
				'type'        => 'button',
				'offset'      => 400,
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Change the title text', 'woodmart' ),
				'description' => esc_html__( 'Update the text in the title block as needed. Once you\'ve made your changes, click "Next" to proceed.', 'woodmart' ),
				'selector'    => '.is-root-container > .wp-block-wd-title, .is-root-container > .wp-block-wd-container > .block-editor-inner-blocks > .block-editor-block-list__layout > .wp-block-wd-title',
				'type'        => 'info',
				'allow_click' => true,
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Open the sidebar settings', 'woodmart' ),
				'description' => esc_html__( 'Click on the "Settings" icon in the top right corner of the editor to open the sidebar panel. This panel contains various settings for the selected block.', 'woodmart' ),
				'selector'    => '#editor .editor-header .interface-pinned-items .components-button[aria-controls="edit-post:block"]',
				'type'        => 'button',
				'step'        => 2,
				'skip_if'     => "jQuery('.interface-complementary-area.editor-sidebar').length",
			),
			array(
				'title'       => esc_html__( 'Adjust the title element settings', 'woodmart' ),
				'description' => esc_html__( 'The sidebar will display the settings for the title element, including options for style, color, design, appearance, positioning, and more. Adjust these settings as needed, and once you\'re satisfied, click "Next" to proceed.', 'woodmart' ),
				'selector'    => '#editor .interface-complementary-area.editor-sidebar',
				'type'        => 'info',
				'allow_click' => true,
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Save the page', 'woodmart' ),
				'description' => esc_html__( 'After making all the necessary changes to the title element, click the "Save" button to save your changes.', 'woodmart' ),
				'selector'    => '.editor-header__settings > .components-button.editor-post-publish-button',
				'type'        => 'button',
				'step'        => 3,
				'is_done'     => "var i=setInterval(()=>{if(jQuery('.components-snackbar-list > div').length){clearInterval(i);callback()}},500);",
			),
			array(
				'title'       => esc_html__( 'All done!', 'woodmart' ),
				'description' => esc_html__( 'Your homepage title has been successfully updated – the changes are now live. Click the "Done" button to finish.', 'woodmart' ),
				'selector'    => '#editor .interface-interface-skeleton__content',
				'type'        => 'info',
				'step'        => 3,
			),
		),
	),
	7 => array(
		'title'       => esc_html__( 'Modifying the site content via WPBakery', 'woodmart' ),
		'description' => esc_html__( 'Find out how to update the homepage title step by step.', 'woodmart' ),
		'url'         => admin_url( 'admin.php?page=xts_dashboard' ),
		'requires'    => 'wpb' === woodmart_get_current_page_builder() && get_post_meta( get_option( 'page_on_front' ), 'woodmart_shortcodes_custom_css', true ),
		'steps'       => array(
			array(
				'title'       => esc_html__( 'Go to the Homepage', 'woodmart' ),
				'description' => esc_html__( 'Click the site name in the top admin bar to navigate to the homepage of your website.', 'woodmart' ),
				'selector'    => '#wpadminbar #wp-admin-bar-site-name > a',
				'type'        => 'button',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Homepage overview', 'woodmart' ),
				'description' => esc_html__( 'This is the homepage of your website. It displays the content that visitors see first, including banners, titles, and key sections.', 'woodmart' ),
				'selector'    => 'body',
				'type'        => 'info',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Edit the page', 'woodmart' ),
				'description' => esc_html__( 'Click the "Edit page" button in the top admin bar to open the homepage in the WPBakery editor.', 'woodmart' ),
				'selector'    => '#wpadminbar #wp-admin-bar-edit > a',
				'type'        => 'button',
				'step'        => 1,
			),
			array(
				'title'       => esc_html__( 'Page editor overview', 'woodmart' ),
				'description' => esc_html__( 'You are now in the WordPress page editor. When using WPBakery, this page serves as a transitional screen between WordPress and the WPBakery editor. Click "Next" to proceed.', 'woodmart' ),
				'selector'    => 'body.wp-admin',
				'type'        => 'info',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Switch to WPBakery', 'woodmart' ),
				'description' => esc_html__( 'Click on the "WPBakery Page Builder" button to launch the WPBakery page builder and start editing the content of your page with its powerful tools.', 'woodmart' ),
				'selector'    => '.editor-header .wpb_switch-to-composer, #post-body-content .wpb_switch-to-composer',
				'type'        => 'button',
				'step'        => 2,
				'skip_if'     => "jQuery('.wrap #wpb_wpbakery.postbox').length || jQuery('#postdivrich').length && jQuery('#postdivrich').hasClass('vc-disable-editor')",
			),
			array(
				'title'       => esc_html__( 'WPBakery editor overview', 'woodmart' ),
				'description' => esc_html__( 'You are now inside the WPBakery Page Builder editor. Here, you can visually manage your page content using rows, columns, and content elements.', 'woodmart' ),
				'selector'    => 'form #wpb_wpbakery',
				'type'        => 'info',
				'step'        => 2,
			),
			array(
				'title'       => esc_html__( 'Select the "Section title" element', 'woodmart' ),
				'description' => esc_html__( 'This is your website "Section title" element. Hover over it and click the "Pencil" icon to continue.', 'woodmart' ),
				'selector'    => 'form #wpb_wpbakery .wpb_content_element.wpb_woodmart_title',
				'type'        => 'button',
				'step'        => 3,
				'is_done'     => "var i=setInterval(()=>{if(!jQuery('#vc_ui-panel-edit-element.vc_active .vc_ui-panel-content').hasClass('vc_properties-list-init')){clearInterval(i);callback()}},500);",
			),
			array(
				'title'       => esc_html__( 'Edit the element settings', 'woodmart' ),
				'description' => esc_html__( 'Here, you can change the title, subtitle, and description, as well as their colors and styles. When you\'re done, click "Next".', 'woodmart' ),
				'selector'    => '#vc_ui-panel-edit-element.vc_active .vc_ui-panel-window-inner',
				'type'        => 'info',
				'allow_click' => true,
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Save element changes', 'woodmart' ),
				'description' => esc_html__( 'Done! The title element has been successfully updated. Click "Save changes" to continue.', 'woodmart' ),
				'selector'    => '#vc_ui-panel-edit-element.vc_active .vc_ui-panel-footer-container .vc_general.vc_ui-button[data-vc-ui-element="button-save"]',
				'type'        => 'button',
				'step'        => 3,
			),
			array(
				'title'       => esc_html__( 'Save the page', 'woodmart' ),
				'description' => esc_html__( 'Click the "Update" button to save all changes made to the page.', 'woodmart' ),
				'selector'    => 'form #submitpost #publishing-action input[name="save"]',
				'type'        => 'button',
				'step'        => 4,
				'is_done'     => "var i=setInterval(()=>{if(jQuery('#message.updated').length){clearInterval(i);callback()}},1000);",
				'skip_if'     => "jQuery('#message.updated').length",
			),
			array(
				'title'       => esc_html__( 'All done!', 'woodmart' ),
				'description' => esc_html__( 'You\'ve successfully updated the title element using WPBakery Page Builder. Click the "Done" button to finish.', 'woodmart' ),
				'selector'    => '#poststuff',
				'type'        => 'info',
				'step'        => 4,
			),
		),
	),
);
